// LAB:14 Perforrm the Following Transform on Gray Scale Image. 
//(I)DFT (II)DCT (III)DWT
// Version : Scilab 5.4.1
// Operating System : Window-xp, Window-7
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.1-2
//Toolbox: Wavelet


clc;
clear;
xdel(winsid());
path=getSIVPpath();
Image=imread(path+"images\lena.png");
gray=im2double(rgb2gray(Image));
//ShowImage(gray,"gray image");
//title("grayscale",'fontsize',3 );
imwrite(gray,'LAB14_1.jpg');

///////////// DFT //////////////////////////
h1=fft2(gray);//fft2() is used to find 2-Dimensional Fast Fourier Transform of an matrix
i1=log(1+abs(h1));
in1=fftshift(i1);//fftshift() is used to rearrange the fft output, moving the zero frequency
inm1=mat2gray(in1);
//figure;
//ShowImage(inm1,'Frequency Spectrum of Original Image');
//title("Frequency Spectrum",'fontsize',3 );
imwrite(inm1,'LAB14_2.jpg');

/////////////// DCT ////////////////////////
h2=dct(gray,1); // DCT Transfom 
//figure;
//ShowImage(h2,'Frequency Spectrum of Original Image');
//title("DCT Coefficient",'fontsize',3 );
imwrite(h2,'LAB14_3.jpg');
h3=idct(h2); // IDCT Transfom 
h4=mat2gray(h3);
//figure;
//ShowImage(h4,'Frequency Spectrum of Original Image');
//title("Recovered Image using DCT Coefficient",'fontsize',3 );
imwrite(h4,'LAB14_4.jpg');

/////////////// DWT /////////////////////////
[CA CH CV CD]=dwt2(gray,'db2','mode','asymh');
[M N]=size(CA);
temp=[CA ones(M,10) CH ones(M,10) CV ones(M,10) CD]; //Padding Data for Displayng DWT Coefficients 
//figure;ShowImage(temp,"CA CH CV CD DWT Coefficient");
//title("CA CH CV CD DWT Coefficient",'fontsize',3 );
imwrite(temp,'LAB14_5.jpg');

x1=size(gray);
X = idwt2(CA,CH,CV,CD,'db2',x1); // Inverse DWT
//figure;ShowImage(X,'Recovered Image');
//title('inverse dwt','fontsize',3);
imwrite(X,'LAB14_6.jpg');
